<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Users Details | <?php echo (is_settings('app_name')) ? is_settings('app_name') : "" ?></title>

    <?php base_url() . include 'include.php'; ?>
</head>

<body>
    <div id="app">
        <div class="main-wrapper">
            <?php base_url() . include 'header.php'; ?>

            <!-- Main Content -->
            <div class="main-content">
                <section class="section">
                    <div class="section-header">
                        <h1>Users Details <small>View / Update </small></h1>
                    </div>
                    <div class="section-body">

                        <div class="row">
                            <div class="col-12">
                                <div class="card">

                                    <div class="card-body">
                                        <table aria-describedby="mydesc" class='table-striped' id='user_list' data-toggle="table" data-url="<?= base_url() . 'Table/users' ?>" data-click-to-select="true" data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 20, 50, 100, 200, All]" data-search="true" data-toolbar="#toolbar" data-show-columns="true" data-show-refresh="true" data-trim-on-search="false" data-mobile-responsive="true" data-sort-name="id" data-sort-order="desc" data-maintain-selected="true" data-pagination-successively-size="3" data-show-export="true" data-export-types='["csv","excel","pdf"]' data-export-options='{ "fileName": "user-list-<?= date('d-m-y') ?>" }' data-query-params="queryParams">
                                            <thead>
                                                <tr>
                                                    <th scope="col" data-field="id" data-sortable="true" data-align="center">ID</th>
                                                    <th scope="col" data-field="profile" data-sortable="false">Profile</th>
                                                    <th scope="col" data-field="name" data-sortable="true">Name</th>
                                                    <th scope="col" data-field="email" data-sortable="true">Email</th>
                                                    <th scope="col" data-field="mobile" data-sortable="true">Mobile</th>
                                                    <th scope="col" data-field="type" data-sortable="false">Type</th>
                                                    <th scope="col" data-field="coins" data-sortable="true">Coins</th>
                                                    <th scope="col" data-field="refer_code" data-sortable="true" data-visible="false">Refer Code</th>
                                                    <th scope="col" data-field="friends_code" data-sortable="true" data-visible="false">Friends Code</th>
                                                    <th scope="col" data-field="remove_ads" data-sortable="true" data-visible="false" data-align="center">Remove Ads</th>
                                                    <th scope="col" data-field="fcm_id" data-sortable="true" data-visible="false">FCM ID</th>
                                                    <th scope="col" data-field="status" data-sortable="false">Status</th>
                                                    <th scope="col" data-field="date_registered" data-sortable="true">Register Date</th>
                                                    <th scope="col" data-field="operate" data-sortable="false" data-events="actionEvents" data-force-hide="true">Operate</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </section>
            </div>
        </div>
    </div>

    <div class="modal fade" tabindex="-1" role="dialog" id="editDataModal">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit User</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="card-body">
                        <form method="post" class="needs-validation" novalidate="" enctype="multipart/form-data">
                            <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                            <input type='hidden' name="edit_id" id="edit_id" value="" />

                            <div class="form-group row">
                                <div class="col-md-12 col-sm-12">
                                    <label class="control-label">Status</label><br />
                                    <div id="status" class="btn-group">
                                        <label class="btn btn-default">
                                            <input type="radio" name="status" value="1"> Active
                                        </label>
                                        <label class="btn btn-danger">
                                            <input type="radio" name="status" value="0"> Deactive
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="float-right">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <input name="btnupdate" type="submit" value="Save changes" class="<?= BUTTON_CLASS ?>">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <!-- //---- -->




    <div class="modal fade" tabindex="-1" role="dialog" id='coinsmodal'>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Coins to User</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="card-body">
                        <form method="post" class="needs-validation" novalidate="" enctype="multipart/form-data">
                            <input type="hidden" name="<?= $this->security->get_csrf_token_name(); ?>" value="<?= $this->security->get_csrf_hash(); ?>">
                            <input type='hidden' name="user_id_coin" id="user_id_coin" value='' />
                            <div class="form-group row">
                                <div class="col-md-12 col-sm-12">


                                    <label class="control-label">Coins</label><br />
                                    <div id="status" class="btn-group">
                                        <input class="form-control" type="number" name="coins" id="coins" value="" min=1 placeholder="Enter Coins">

                                    </div>
                                </div>
                            </div>

                            <div class="float-right">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <input name="btnupdateCoins" type="submit" value="Save changes" class="<?= BUTTON_CLASS ?>">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <!-- //------------------- -->



    <?php base_url() . include 'footer.php'; ?>

    <script type="text/javascript">
        function queryParams(p) {
            return {
                sort: p.sort,
                order: p.order,
                offset: p.offset,
                limit: p.limit,
                search: p.search
            };
        }
    </script>

    <script type="text/javascript">
        window.actionEvents = {
            'click .edit-data': function(e, value, row, index) {
                $('#edit_id').val(row.id);
                $("input[name=status][value=1]").prop('checked', true);
                if ($(row.status).text() == 'Deactive')
                    $("input[name=status][value=0]").prop('checked', true);
            },
            'click .admin-coin': function(e, value, row, index) {


                $('#user_id_coin').val(row.id);
                // $('#coins').val(row.coins);


            }
        };
    </script>

</body>

</html>